/*
 * Copyright (c) 2016, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */


/**
 * \file    Boot-Mode.c
 *
 * \brief   Main Entry Function for Boot-Mode testing.
 *
 * This file contains the Main routine for testing 
 * Bootmode of the DM8127 EVM.
 * 
 * \ author
 * 
 * \version  
 */
 
/* ======================
 *  Includes
 * ======================
 */
#include "DM8127_EVM.h"
#include "DM8127s_soc.h"
#include "Dm8127_Platform.h"
#include "DM8127_types.h"
#include "stdio.h"

/* =====================
 * Defines
 * =====================
 */
#define DM8127_BOOT_MODE_ADDR	(0x48140040)

/** **************************************************************************
 * \n \main rotuine to test the BOOt-Mode.
 *
 * This routine reads the Boot mode switch and verifes the same. 
 * 
 * 
 */
int main()
{
	UINT32	u32BootMode = 0;

    /* Initialize EVM */
	UART_Init();
	
	platform_write ("Reading the boot mode switch settings !!.\r\n");
	u32BootMode = *(UINT32*) DM8127_BOOT_MODE_ADDR;

	platform_write("Boot-Mode switch settings read is 0x%x\n", u32BootMode);

	return 0;

}
 

    
   
